<!DOCTYPE html>
<?php
include('connect.php'); 
session_start();

$timeout_duration = 900; // المهلة بالثواني

if (isset($_SESSION['LAST_ACTIVITY']) && (time() - $_SESSION['LAST_ACTIVITY']) > $timeout_duration) {
    session_unset();
    session_destroy();
    header("Location: login.php?timeout=1");
    exit;
}
$_SESSION['LAST_ACTIVITY'] = time();

// معالجة حفظ التقرير الجديد
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['save_report'])) {
    $report_date = $_POST['report_date'] ?? '';
    $sales = $_POST['sales'] !== '' ? $_POST['sales'] : 0;
    $expenses = $_POST['expenses'] !== '' ? $_POST['expenses'] : 0;
    $notes = $_POST['notes'] ?? '';

    if ($report_date && is_numeric($sales) && is_numeric($expenses)) {
        $stmt = $con->prepare("INSERT INTO reports (employee_name, report_date, sales, expenses, notes) VALUES (?, ?, ?, ?, ?)");
        $stmt->bind_param("ssdds", $_SESSION['username'], $report_date, $sales, $expenses, $notes);
        $stmt->execute();
        $stmt->close();

        // --- إنشاء محتوى الطباعة ---
        $print_content = "
تقرير المبيعات اليومي
-----------------------
الموظف: {$_SESSION['username']}
التاريخ: {$report_date}
المبيعات: ₪ {$sales}
المصاريف: ₪ {$expenses}
الملاحظات: {$notes}
-----------------------
";

        // --- حفظ المحتوى في ملف نصي مؤقت ---
        $file_name = "print_report_" . time() . ".txt";
        file_put_contents($file_name, $print_content);

        // حذف الملف المؤقت إذا رغبت
        unlink($file_name);
        // إعادة التوجيه
header("Location: print_report.php");
        exit;
    }
}

// جلب جميع التقارير
$stmt = $con->prepare("SELECT report_date, sales, expenses, notes, entry_time FROM reports WHERE employee_name = ? ORDER BY report_date DESC");
$stmt->bind_param("s", $_SESSION['username']);
$stmt->execute();
$result = $stmt->get_result();
$reports = $result->fetch_all(MYSQLI_ASSOC);
$stmt->close();

$stmt = $con->prepare("SELECT SUM(expenses), SUM(sales), COUNT(*) FROM reports WHERE employee_name = ?");
$stmt->bind_param("s", $_SESSION['username']);
$stmt->execute();
$stmt->bind_result($total_expenses, $total_sales, $report_count);
$stmt->fetch();
$stmt->close();
?>

<html lang="ar" dir="rtl">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>لوحة الموظف</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.rtl.min.css" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
  <style>
    body { background: #f4f6f9; font-family: 'Segoe UI', sans-serif; }
    .card { border-radius: 15px; }
    .form-control, .form-select { border-radius: 8px; }
    .btn { border-radius: 8px; }
    .card-summary { display: flex; justify-content: space-between; gap: 10px; flex-wrap: wrap; }
    .summary-box { flex: 1; min-width: 150px; padding: 20px; background: #fff; border-radius: 12px; box-shadow: 0 0 10px rgba(0,0,0,0.05); text-align: center; }
    .summary-box i { display: block; font-size: 20px; margin-bottom: 5px; }
  </style>
</head>
<body>
  <div class="container py-4">
    <div class="text-end mb-3">
      <a href="logout.php" class="btn btn-danger">
        <i class="fa fa-sign-out-alt"></i> تسجيل الخروج
      </a>
    </div>

    <div class="card p-4 mb-4">
      <h4 class="text-end text-primary">مرحباً <?= htmlspecialchars($_SESSION['username']) ?><br><small class="text-muted">لوحة تقارير المبيعات اليومية</small></h4>

      <h5 class="text-end mt-4"><i class="fa fa-chart-pie"></i> إحصائيات الشهر الحالي</h5>
      <div class="card-summary mt-3">
        <div class="summary-box">
          <i class="fa fa-credit-card text-danger"></i>
          <div>إجمالي المصاريف</div>
          <strong><?= number_format($total_expenses ?? 0, 2) ?> ₪</strong>
        </div>
        <div class="summary-box">
          <i class="fa fa-money-bill-wave text-success"></i>
          <div>إجمالي المبيعات</div>
          <strong><?= number_format($total_sales ?? 0, 2) ?> ₪</strong>
        </div>
        <div class="summary-box">
          <i class="fa fa-file-alt text-primary"></i>
          <div>عدد التقارير</div>
          <strong><?= $report_count ?? 0 ?></strong>
        </div>
      </div>
    </div>

    <div class="card p-4 mb-4">
      <h5 class="text-end"><i class="fa fa-pen"></i> إدخال تقرير يومي جديد</h5>
      <form method="post">
        <input type="hidden" name="save_report" value="1" />
        <div class="row g-3 mt-3">
          <div class="col-md-3">
            <label>التاريخ</label>
            <input type="date" name="report_date" class="form-control" required value="<?= date('Y-m-d') ?>" />
          </div>
          <div class="col-md-3">
            <label>مبلغ المبيعات (₪)</label>
            <input type="number" step="0.01" name="sales" class="form-control" required value="0" />
          </div>
          <div class="col-md-3">
            <label>مبلغ المصاريف (₪)</label>
            <input type="number" step="0.01" name="expenses" class="form-control" required value="0" />
          </div>
          <div class="col-md-3">
            <label>ملاحظات (اختياري)</label>
            <textarea name="notes" class="form-control" rows="1"></textarea>
          </div>
          <div class="col-12 text-end">
            <button type="submit" class="btn btn-primary"><i class="fa fa-save"></i> حفظ التقرير</button>
          </div>
        </div>
      </form>
    </div>

    <div class="card p-4">
      <h5 class="text-end"><i class="fa fa-clock"></i> تقاريري السابقة</h5>
      <div class="table-responsive mt-3">
        <table class="table table-bordered text-center align-middle">
          <thead class="table-light">
            <tr>
              <th>التاريخ</th>
              <th>المبيعات</th>
              <th>المصاريف</th>
              <th>الملاحظات</th>
            </tr>
          </thead>
          <tbody>
            <?php if (count($reports) > 0): ?>
              <?php foreach ($reports as $report): ?>
                <tr>
                  <td><?= date('H:i d-m-Y', strtotime($report['entry_time'])) ?><br><small><?= date('l', strtotime($report['report_date'])) ?></small></td>
                  <td class="text-success"><?= number_format($report['sales'] ?? 0, 2) ?></td>
                  <td class="text-danger"><?= number_format($report['expenses'] ?? 0, 2) ?></td>
                  <td><?= htmlspecialchars($report['notes'] ?? '') ?></td>
                </tr>
              <?php endforeach; ?>
            <?php else: ?>
              <tr><td colspan="5">لا توجد تقارير لعرضها حالياً.</td></tr>
            <?php endif; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
</body>
</html>
