<?php
include('connect.php');
session_start();

$timeout_duration = 900;

// Session timeout check
if (isset($_SESSION['LAST_ACTIVITY']) && (time() - $_SESSION['LAST_ACTIVITY']) > $timeout_duration) {
    session_unset();
    session_destroy();
    header("Location: login.php?timeout=1");
    exit;
}
$_SESSION['LAST_ACTIVITY'] = time();
$message = "";

// Delete single report
if (isset($_GET['delete']) && is_numeric($_GET['delete'])) {
    $delete_id = intval($_GET['delete']);
    $stmt = $con->prepare("DELETE FROM reports WHERE id = ?");
    $stmt->bind_param("i", $delete_id);
    if ($stmt->execute()) $message = "تم حذف التقرير بنجاح.";
    else $message = "حدث خطأ أثناء الحذف.";
}

// Delete all reports
if (isset($_GET['delete_all']) && $_GET['delete_all'] == 1) {
    $stmt = $con->prepare("DELETE FROM reports");
    if ($stmt->execute()) $message = "تم حذف جميع التقارير بنجاح.";
    else $message = "حدث خطأ أثناء حذف جميع التقارير.";
}

// Edit report
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['edit_id_modal'])) {
    $id = intval($_POST['edit_id_modal']);
    $sales = floatval($_POST['sales_modal']);
    $expenses = floatval($_POST['expenses_modal']);
    $notes = $_POST['notes_modal'];
    $stmt = $con->prepare("UPDATE reports SET sales = ?, expenses = ?, notes = ? WHERE id = ?");
    $stmt->bind_param("ddsi", $sales, $expenses, $notes, $id);
    if ($stmt->execute()) $message = "تم تعديل التقرير بنجاح.";
    else $message = "حدث خطأ أثناء التعديل.";
}

// Get filters
$employee = $_GET['employee'] ?? '';

$users_result = $con->query("SELECT username FROM users ORDER BY username ASC");
$users = [];
while ($u = $users_result->fetch_assoc()) {
    $users[] = $u['username'];
}

$conditions = [];
$params = [];
$types = "";

if (!empty($employee)) {
    $conditions[] = "employee_name = ?";
    $params[] = $employee;
    $types .= "s";
}

$sql = "SELECT * FROM reports";
if (!empty($conditions)) $sql .= " WHERE " . implode(" AND ", $conditions);
$sql .= " ORDER BY report_date DESC, entry_time DESC";

$stmt = $con->prepare($sql);
if (!empty($params)) $stmt->bind_param($types, ...$params);
$stmt->execute();
$result = $stmt->get_result();

$sum_sales = 0;
$sum_expenses = 0;
$reports = [];
while ($row = $result->fetch_assoc()) {
    $sum_sales += $row['sales'];
    $sum_expenses += $row['expenses'];
    $reports[] = $row;
}
$balance = $sum_sales - $sum_expenses;
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="UTF-8">
  <title>لوحة المدير</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.rtl.min.css" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
  <style>
    body { background: #f4f6f9; font-family: 'Segoe UI', sans-serif; }
    .card { border-radius: 15px; }
    .search-btn { background-color: #007bff; color: white; }
    .summary-values span { font-weight: bold; margin-left: 15px; }
    .table td, .table th { vertical-align: middle; }
    .toast-container { position: fixed; top: 1rem; left: 1rem; z-index: 1080; }
  </style>
</head>
<body>
<div class="container py-4">
  <div class="text-end mb-3">
    <a href="logout.php" class="btn btn-danger"><i class="fa fa-sign-out-alt"></i> تسجيل الخروج</a>
    <a href="users.php" class="btn btn-secondary me-2"><i class="fa fa-users-cog"></i> التحكم في المستخدمين</a>
    <a href="?delete_all=1" class="btn btn-danger me-2" onclick="return confirm('هل أنت متأكد من حذف جميع التقارير؟');">
      <i class="fas fa-trash-alt"></i> حذف جميع التقارير
    </a>
  </div>

  <?php if (!empty($message)): ?>
    <div class="alert alert-info text-center"> <?= $message ?> </div>
  <?php endif; ?>

  <div class="card p-4 mb-3">
    <div class="d-flex justify-content-end">
      <h4 class="mb-4"><i class="fas fa-chart-bar"></i> لوحة المدير</h4>
    </div>
    <form method="get" class="row align-items-end">
      <div class="col-md-3">
        <label>اسم الموظف</label>
        <select name="employee" class="form-select">
          <option value="">الكل</option>
          <?php foreach ($users as $name): ?>
            <option value="<?= $name ?>" <?= $employee == $name ? 'selected' : '' ?>><?= $name ?></option>
          <?php endforeach; ?>
        </select>
      </div>
      <div class="col-md-3">
        <button class="btn search-btn w-100" type="submit"><i class="fas fa-search"></i> بحث</button>
      </div>
    </form>
    <div class="mt-4">
      <h5><i class="fas fa-chart-line"></i> إجمالي التقارير اليومي</h5>
      <div class="summary-values d-flex justify-content-end">
        <span class="text-success"><i class="fa fa-money-bill-wave"></i> إجمالي المبيعات: <?= number_format($sum_sales, 2) ?></span>
        <span class="text-danger"><i class="fa fa-credit-card"></i> إجمالي المصاريف: <?= number_format($sum_expenses, 2) ?></span>
        <span class="text-primary"><i class="fa fa-cash-register"></i> المتوفر في الصندوق: <?= number_format($balance, 2) ?></span>
      </div>
    </div>
  </div>

  <div class="card p-3">
    <div class="table-responsive">
      <table class="table table-bordered text-center">
        <thead class="table-light">
          <tr>
            <th>الموظف</th>
            <th>التاريخ</th>
            <th>المبيعات</th>
            <th>المصاريف</th>
            <th>الملاحظات</th>
            <th>تحكم</th>
          </tr>
        </thead>
        <tbody>
          <?php foreach ($reports as $report): ?>
            <tr>
              <td><?= $report['employee_name'] ?></td>
              <td>
                  <?= date('H:i d-m-Y', strtotime($report['entry_time'])) ?><br>
                  <small><?= date('l', strtotime($report['report_date'])) ?></small>
              </td>
              <td class="text-success"><?= number_format($report['sales'], 2) ?></td>
              <td class="text-danger"><?= number_format($report['expenses'], 2) ?></td>
              <td><?= $report['notes'] ?></td>
              <td>
                <button class="btn btn-warning btn-sm" data-bs-toggle="modal" data-bs-target="#editModal<?= $report['id'] ?>">
                  <i class="fas fa-edit"></i>
                </button>
                <a href="?delete=<?= $report['id'] ?>" class="btn btn-danger btn-sm" onclick="return confirm('هل أنت متأكد من الحذف؟');">
                  <i class="fas fa-trash"></i>
                </a>
              </td>
            </tr>
          <?php endforeach; ?>
        </tbody>
      </table>
    </div>
  </div>

  <?php foreach ($reports as $report): ?>
    <div class="modal fade" id="editModal<?= $report['id'] ?>" tabindex="-1">
      <div class="modal-dialog">
        <form method="post" class="modal-content">
          <div class="modal-header">
            <h5 class="modal-title">تعديل التقرير</h5>
            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
          </div>
          <div class="modal-body">
            <input type="hidden" name="edit_id_modal" value="<?= $report['id'] ?>">
            <div class="mb-3">
              <label>المبيعات</label>
              <input type="number" name="sales_modal" step="0.01" class="form-control" value="<?= $report['sales'] ?>">
            </div>
            <div class="mb-3">
              <label>المصاريف</label>
              <input type="number" name="expenses_modal" step="0.01" class="form-control" value="<?= $report['expenses'] ?>">
            </div>
            <div class="mb-3">
              <label>ملاحظات</label>
              <input type="text" name="notes_modal" class="form-control" value="<?= $report['notes'] ?>">
            </div>
          </div>
          <div class="modal-footer">
            <button type="submit" class="btn btn-primary">حفظ التغييرات</button>
            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إغلاق</button>
          </div>
        </form>
      </div>
    </div>
  <?php endforeach; ?>
</div>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
